/*******************************************************************************************************
 *                                                                                                     *
 *        **********                                                                                   *
 *       ************                                                                                  *
 *      ***        ***                                                                                 *
 *      ***   +++   ***                                                                                *
 *      ***   + +   ***                                                                                *
 *      ***   +                                     CHIPCON CC2420 SOFTWARE                            *
 *      ***   + +   ***                              Master inclusion file                             *
 *      ***   +++   ***                                                                                *
 *      ***        ***                                                                                 *
 *       ************                                                                                  *
 *        **********                                                                                   *
 *                                                                                                     *
 *******************************************************************************************************
 * This file shall be included in all source files (*.c). No other library inclusions are required.    *
 *******************************************************************************************************
 * Compiler: AVR-GCC, MSP430-GCC, IAR C/C++ for MSP430                                                                                  *
 * Target platform: CC2420DB, CC2420                                           *
 *******************************************************************************************************
 * Revision history:                                                                                   *
 * $Log: include.h,v $
 * Revision 1.5  2004/04/02 12:27:32  oyj
 * Added mac_security.h
 *
 * Revision 1.4  2004/03/30 15:00:26  mbr
 * Release for web
 *  
 *
 *
 *
 *******************************************************************************************************/
#ifndef INCLUDE_H
#define INCLUDE_H


//-------------------------------------------------------------------------------------------------------
// Common data types
typedef unsigned char		BOOL;

typedef unsigned char		BYTE;
typedef unsigned short		WORD;
typedef unsigned long		DWORD;
typedef unsigned long long	QWORD;

typedef unsigned char		UINT8;
typedef unsigned short		UINT16;
typedef unsigned long		UINT32;
typedef unsigned long long	UINT64;

typedef signed char		INT8;
typedef signed short		INT16;
typedef signed long		INT32;
typedef signed long long	INT64;

// Common values
#ifndef FALSE
	#define FALSE 0
#endif
#ifndef TRUE
	#define TRUE 1
#endif
#ifndef NULL
	#define NULL 0
#endif

// Useful stuff
#define BM(n) (1 << (n))
#define BF(x,b,s) (((x) & (b)) >> (s))
#define MIN(n,m) (((n) < (m)) ? (n) : (m))
#define MAX(n,m) (((n) < (m)) ? (m) : (n))
#define ABS(n) ((n < 0) ? -(n) : (n))

// Dynamic function pointer
typedef void (*VFPTR)(void);

#include <string.h>

//-------------------------------------------------------------------------------------------------------



/////////////////////////////////////////////////////////////////
// MSP430-GCC C/C++ compiler for MSP430 (__MSP430__)
// IAR 3.2 C/C++ compiler for MSP430 (__ICC430__)
#if defined(__ICC430__) || defined(__MSP430__)
// Include files for MSP430
#include <msp430x16x.h>
#ifdef __MSP430__
    #include <signal.h>
#endif
#ifdef __ICC430__
    #pragma diag_suppress=Pa082
#endif
#include "hal_msp430FET.h"
#include "hal.h"
#endif

////////////////////////////////////////////////////////////////////
// Common include files
#include "hal_cc2420.h"
#include "basic_rf.h"

//-------------------------------------------------------------------------------------------------------

#endif
